/* Skripte zur Auswahl von Spalten 
 * Auszufuehren als Benutzer SCOTT
 */

-- einfachst moegliche SQL-Anweisung
select *
  from emp;
  
-- einfache Spaltenauswahl
select ename, job, sal
  from emp;
  
-- Spalten mehrfach auswaehlen
select job, ename, job, sal, sal
  from emp;
  
-- Berechnung des neuen Gehalts
select ename, job, sal, sal * 1.03
  from emp;
  
-- Zeichenketten konkatenieren
select ename || job
  from emp;
  
-- Zeichenketten mit Leerzeichen konkatenieren
select ename || ' ' || job
  from emp;
  
-- Ausgabe einer konstanten Zeichenkette
select 'Willi hat Durst!', 17
  from emp;

-- ein einfaches Alias verwenden
select ename mitarbeiter, job beruf
  from emp;
  
-- Spaltenalias mit dem Schluesselwort AS und Maskierung einer Formel
select ename as mitarbeiter, (12*sal) as jahresgehalt
  from emp;
  
-- Spaltenalias mit Sonderzeichen
select ename as "Mitarbeiter", (12*sal) as "S Gehalt/Jahr"
  from emp;
  
-- Spaltenlias mit Sonderzeichen und Tabellenalias
select e.ename as "Mitarbeiter", (12 * e.sal) as "S Gehalt/Jahr"
  from emp e;

-- Falsche Berechnung des Jahresgehaltes
select ename mitarbeiter,
       (12 * sal ) + comm jahresgehalt
  from emp;
  
-- Korrigierte Berechnung des Jahresgehaltes
select ename mitarbeiter,
       (12 * sal ) + nvl(comm, 120) jahresgehalt
  from emp;
  
 